/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import com.nokia.mid.appl.calc2.Local;
import common.util.Calculator;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public final class Tools {
    private static final Tools instance = new Tools();
    private long timeOfLastGarbageCollection = 0L;

    private Tools() {
    }

    public static Tools getInstance() {
        return instance;
    }

    public Image loadImage(String filePath) {
        if (filePath == null) {
            return null;
        }
        Image image = null;
        try {
            image = Image.createImage((String)filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
        return image;
    }

    public void triggerGarbageCollection() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.timeOfLastGarbageCollection > 5000L) {
            this.timeOfLastGarbageCollection = currentTime;
            System.gc();
            Thread.yield();
        }
    }

    public double roundDouble(double number, int numberOfDigitsToRound) {
        if (numberOfDigitsToRound < 0) {
            return number;
        }
        try {
            double factor = Calculator.getInstance().pow(10.0, numberOfDigitsToRound);
            return (double)((int)(number * factor + 0.5)) / factor;
        }
        catch (ArithmeticException exception) {
            return number;
        }
    }

    public String replaceDecimalSeparator(String input) {
        if (input == null) {
            return "";
        }
        char decimalSeparator = ".".charAt(0);
        char visibleDecimalSeparator = Local.getText(27).charAt(0);
        return input.replace(decimalSeparator, visibleDecimalSeparator);
    }

    public String doubleToString(double doubleValue) {
        if (Double.isNaN(doubleValue)) {
            return null;
        }
        if (Double.isInfinite(doubleValue)) {
            return null;
        }
        String stringValue = Double.toString(doubleValue);
        int exponentPosition = stringValue.indexOf(69);
        if (exponentPosition >= 0) {
            int exponent = Integer.parseInt(stringValue.substring(exponentPosition + 1));
            String mantisseHead = stringValue.substring(stringValue.indexOf(".") - 1, stringValue.indexOf("."));
            String mantisseTail = stringValue.substring(stringValue.indexOf(".") + 1, exponentPosition);
            stringValue = stringValue.charAt(0) == "-".charAt(0) ? "-" : "";
            stringValue = exponent < 0 ? stringValue + "0" + "." + this.zeros(Math.abs(exponent + 1)) + mantisseHead + mantisseTail : (exponent < mantisseTail.length() ? stringValue + mantisseHead + mantisseTail.substring(0, exponent) + "." + mantisseTail.substring(exponent) : stringValue + mantisseHead + mantisseTail + this.zeros(exponent - mantisseTail.length()));
        }
        return this.removeTrailingZeros(stringValue);
    }

    public String doubleToStringRounded(double doubleValue, int numberOfDigits) {
        String stringValue = this.doubleToString(doubleValue);
        if (stringValue == null) {
            return null;
        }
        if (stringValue.length() > numberOfDigits) {
            int roundDigit = numberOfDigits;
            if (stringValue.indexOf(".") == numberOfDigits) {
                ++roundDigit;
            }
            if (stringValue.charAt(roundDigit) >= '5') {
                while (--roundDigit >= 0) {
                    if (stringValue.charAt(roundDigit) == ".".charAt(0)) continue;
                    if (stringValue.charAt(roundDigit) != '9') break;
                    stringValue = stringValue.substring(0, roundDigit) + "0" + stringValue.substring(roundDigit + 1);
                }
                stringValue = stringValue.charAt(0) == "-".charAt(0) ? (roundDigit == 0 ? "-1" + stringValue.substring(1) : "-" + stringValue.substring(1, roundDigit) + (char)(stringValue.charAt(roundDigit) + '\u0001') + stringValue.substring(roundDigit + 1)) : (roundDigit == -1 ? "1" + stringValue : stringValue.substring(0, roundDigit) + (char)(stringValue.charAt(roundDigit) + '\u0001') + stringValue.substring(roundDigit + 1));
            }
            if (stringValue.substring(0, Math.min(stringValue.length(), numberOfDigits + 1)).indexOf(".") < 0) {
                return null;
            }
        }
        return this.removeTrailingZeros(stringValue.substring(0, Math.min(stringValue.length(), numberOfDigits)));
    }

    public double parseDouble(String value) {
        if (value == null || value.equals("")) {
            return 0.0;
        }
        if (value.equals("\u03c0")) {
            return Math.PI;
        }
        if (value.equals("-\u03c0")) {
            return -Math.PI;
        }
        return Double.parseDouble(value);
    }

    public String removeNegativezero(String string) {
        if (string == null) {
            return "";
        }
        if (string.equals("-0")) {
            return "0";
        }
        return string;
    }

    private String zeros(int zeroCount) {
        StringBuffer zeros = new StringBuffer();
        for (int i = 0; i < zeroCount; ++i) {
            zeros.append("0");
        }
        return zeros.toString();
    }

    private String removeTrailingZeros(String value) {
        if (value != null && value.indexOf(".") > 0) {
            int i = value.length() - 1;
            while (value.charAt(i) == '0') {
                --i;
            }
            if (value.charAt(i) != ".".charAt(0)) {
                ++i;
            }
            return value.substring(0, i);
        }
        return value;
    }
}

